//pattern: "autoinsta",
const { Module } = require("../main");
const { getBuffer, downloadGram } = require("./utils");
const { fromBuffer } = require("file-type");
const botConfig = require("../config");
const axios = require("axios");
const isFromMe = botConfig.MODE === "public" ? false : true;

async function addReaction(message, emoji) {
  let msgKey;
  if (message.reply_message && message.reply_message.id) {
    msgKey = {
      remoteJid: message.reply_message.jid,
      id: message.reply_message.id,
    };
  } else if (message.id) {
    msgKey = {
      remoteJid: message.jid,
      id: message.id,
    };
  } else {
    return;
  }
  const reactionMessage = {
    react: {
      text: emoji,
      key: msgKey,
    },
  };
  await message.client.sendMessage(message.jid, reactionMessage);
}
async function checkRedirect(url) {
  let split_url = url.split("/");
  if (split_url.includes("share")) {
    let res = await axios.get(url);
    return res.request.res.responseUrl;
  }
  return url;
}
Module(
  {
    on: "text",
    fromMe: isFromMe,
  },
  async (message) => {
    const instagramRegex =
      /(?:https?:\/\/)?(?:www\.)?(?:instagram\.com(?:\/.+?)?\/(p|s|reel|tv)\/)([\w-]+)(?:\/)?(\?.*)?$/;
    const facebookRegex =
      /(?:https?:\/\/)?(?:www\.)?(?:facebook\.com|fb\.watch)\/(?:.\/)?(?:videos?\/|watch\/\?v=|.\/posts\/|.\/videos\/|.\/)?(?:\?.*&?v=)?([^&\n?#]+)/;

    let mediaLink = message.message;

    if (instagramRegex.test(mediaLink) || facebookRegex.test(mediaLink)) {
      if (
        mediaLink.toLowerCase().includes("sta h") || mediaLink.toLowerCase().includes("staht")
      )
        return;

      await addReaction(message, "⏳");

      // Handle Instagram links
      if (instagramRegex.test(mediaLink)) {
        const urlMatch = mediaLink.match(instagramRegex);
        if (urlMatch) {
          mediaLink = await checkRedirect(urlMatch[0]);
        }
      }
      // Handle Facebook links - use the link directly
      else if (facebookRegex.test(mediaLink)) {
        const urlMatch = mediaLink.match(facebookRegex);
        if (urlMatch) {
          mediaLink = urlMatch[0];
        }
      }

      try {
        var downloadResult = await downloadGram(mediaLink);
      } catch (error) {
        console.error("Error during auto download:", error);
        await addReaction(message, "❌");
        return await message.sendReply(
          "Something went wrong with download, Please try again!"
        );
      }

      if (downloadResult === false) {
        await addReaction(message, "❌");
        return await message.sendReply("Download failed");
      }

      const quotedMessage = message.reply_message
        ? message.quoted
        : message.data;
      for (const mediaUrl of downloadResult) {
        const mediaBuffer = await getBuffer(mediaUrl);
        const { mime } = await fromBuffer(mediaBuffer);
        await message.sendMessage(
          mediaBuffer,
          mime.includes("video") ? "video" : "image",
          {
            quoted: quotedMessage,
          }
        );
      }
      await addReaction(message, "✅");
    }
  }
);