const {Module} = require('../main');

Module({
    pattern: 'calc ?(.*)',
    fromMe: true,
    desc: 'Calculator with basic operations',
    use: 'utility'
}, async (message, match) => {
    
    if (!match[1]) {
        return await message.reply(`*🔢 WhatsApp Calculator*

*Usage:* .calc operation

*Operations:*
1️⃣ Addition: 2+2
2️⃣ Subtraction: 5-3
3️⃣ Multiplication: 4×3 or 4*3
4️⃣ Division: 9÷3 or 9/3
5️⃣ Exponents: 2^3
6️⃣ Brackets: (4+2)*3

*Example:* .calc 2+2*3`);
    }

    try {
        // Clean the expression
        let expression = match[1]
            .replace(/×/g, '*')
            .replace(/÷/g, '/')
            .replace(/\s+/g, '')
            .replace(/[^0-9+\-*/(). ]/g, '');

        // Validate expression
        if (!/^[0-9+\-*/(). ]+$/.test(expression)) {
            return await message.reply('*❌ Invalid expression!*');
        }

        // Calculate result
        const result = eval(expression);

        if (!isFinite(result)) {
            return await message.reply('*⚠️ Cannot divide by zero!*');
        }

        let response = `*_Expression_:* ${match[1]}\n`;
        response += `*_Result_:* ${result}`;

        await message.reply(response);

    } catch (error) {
        await message.reply('*❌ Invalid calculation!*\nPlease check your expression.');
    }
});

// Scientific calculator
Module({
    pattern: 'scalc ?(.*)',
    fromMe: true,
    desc: 'Scientific calculator',
    use: 'utility'
}, async (message, match) => {
    
    if (!match[1]) {
        return await message.reply(`*📐 Scientific Calculator*

*Functions:*
• sin(x)
• cos(x)
• tan(x)
• sqrt(x)
• log(x)
• abs(x)
• pi

*Example:* .scalc sin(45)`);
    }

    try {
        // Add Math functions
        const mathFuncs = {
            'sin': Math.sin,
            'cos': Math.cos,
            'tan': Math.tan,
            'sqrt': Math.sqrt,
            'log': Math.log,
            'abs': Math.abs,
            'pi': Math.PI
        };

        // Replace math functions in expression
        let expression = match[1].toLowerCase();
        for (let func in mathFuncs) {
            if (expression.includes(func)) {
                expression = expression.replace(
                    new RegExp(func, 'g'),
                    `Math.${func}`
                );
            }
        }

        // Calculate result
        const result = eval(expression);

        let response = `*_Expression_:* ${match[1]}\n`;
        response += `*_Result_:* ${result}`;

        await message.reply(response);

    } catch (error) {
        await message.reply('*❌ Invalid calculation!*\nPlease check your expression.');
    }
});