const { Module } = require('../main');
const axios = require('axios');
const config = require('../config');
const isPrivateBot = config.MODE !== 'public';
Module({
    pattern: 'define ?(.*)',
    fromMe: isPrivateBot,
    desc: 'Looks up the definition of a word.',
    type: 'utility'
}, async (message, match) => {
    const word = match[1];

    if (!word) {
        return await message.sendReply('Please provide a word to define. Example: `.define serendipity`');
    }

    try {
        const apiUrl = `https://api.dictionaryapi.dev/api/v2/entries/en/${word}`;
        const response = await axios.get(apiUrl);
        const data = response.data[0];
        const meaning = data.meanings[0];
        const definition = meaning.definitions[0];

        let responseText = `_*Definition for: \`${data.word}\`* 📖_\n\n`;
        if (data.phonetic) {
            responseText += `- _*Phonetic:* ${data.phonetic}_\n`;
        }
        responseText += `- _*Part of Speech:* ${meaning.partOfSpeech}_\n`;
        responseText += `- _*Meaning:* ${definition.definition}_\n`;
        if (definition.example) {
            responseText += `- _*Example:* \`${definition.example}\`_\n`;
        }

        await message.sendReply(responseText);

    } catch (error) {
        if (error.response && error.response.status === 404) {
            await message.sendReply(`Sorry, I couldn't find a definition for "${word}". Please check the spelling.`);
        } else {
            console.error('_Error fetching definition:_', error);
            await message.sendReply('_An error occurred while fetching the definition. Please try again later._');
        }
    }
});