const { Module } = require('../main');
const axios = require('axios');
const config = require('../config');

// Ensure you have set your Gemini API key using: .setvar GEMINI_API_KEY=your_key
const GEMINI_API_KEY = config.GEMINI_API_KEY;
const GEMINI_API_URL = `https://generativelanguage.googleapis.com/v1beta/models/gemini-2.0-flash:generateContent?key=${GEMINI_API_KEY}`;

/**
 * Gemini Chatbot Plugin
 * Usage: .gemini your question here
 * Responds with Gemini's answer to the prompt.
 */
Module({
    pattern: 'gemini ?(.*)',
    fromMe: false, // Everyone can use
    desc: 'Ask Gemini AI any question',
    type: 'ai'
}, async (message, match) => {
    // Input validation
    if (!GEMINI_API_KEY) return message.reply('❌ Gemini API key missing. Set with .setvar GEMINI_API_KEY=your_key');
    const prompt = match[1]?.trim();
    if (!prompt) return message.reply('Please provide a prompt!\nExample: .gemini What is the capital of France?');

    try {
        // Call Gemini API
        const response = await axios.post(
            GEMINI_API_URL,
            { contents: [{ parts: [{ text: prompt }] }] },
            { headers: { 'Content-Type': 'application/json' } }
        );
        const geminiReply = response.data?.candidates?.[0]?.content?.parts?.[0]?.text;
        await message.reply(geminiReply || '🤖 No response from Gemini.');
    } catch (error) {
        console.error('Gemini API error:', error.message);
        await message.reply('❌ Gemini API error or quota exceeded.');
    }
});