const { Module } = require('../main');
const config = require('../config');

// Set access based on bot mode
const isPrivateBot = config.MODE !== 'public';

Module({
    pattern: 'mee',
    fromMe: isPrivateBot,
    desc: 'Mentions the user who sent the command',
    type: 'fun'
}, async (message) => {
    try {
        // Get the user who sent the command
        const senderNumber = message.sender;
        
        // Send simple mention
        await message.client.sendMessage(message.jid, {
            text: `@${senderNumber.split('@')[0]}`,
            mentions: [senderNumber]
        });
        
    } catch (error) {
        console.error('Error in mee plugin:', error);
        await message.sendReply('❌ Failed to mention user!');
    }
});