const { Module } = require('../main');
const config = require('../config');

// Set isPrivateBot based on config.MODE
const isPrivateBot = config.MODE !== 'public';

// Advanced Python-style calculator with scientific functions
Module({
    pattern: 'pycalc ?(.*)',
    fromMe: isPrivateBot,
    desc: 'Advanced Python-style calculator with scientific functions',
    type: 'utility'
}, async (message, match) => {
    
    if (!match[1]) {
        return await message.reply(`*🐍 Python Advanced Calculator*

*Usage:* .pycalc expression

*Features:*
• Basic arithmetic: +, -, *, /, **
• Scientific functions: sin, cos, tan, log, sqrt
• Constants: pi, e, phi
• Trigonometry: degrees, radians
• Advanced: abs, floor, ceil, round
• Statistics: mean, median, mode
• Algebra: factorial, permutations, combinations

*Examples:*
.pycalc 2**3 + sqrt(16)
.pycalc sin(pi/4) + cos(pi/3)
.pycalc factorial(5) / 2
.pycalc mean([1,2,3,4,5])`);
    }

    try {
        // Import Python calculation module
        const pythonCalc = `
import math
import statistics
from math import *

def calculate(expression):
    try:
        # Safe evaluation with math functions
        safe_dict = {
            'sin': math.sin,
            'cos': math.cos,
            'tan': math.tan,
            'log': math.log,
            'log10': math.log10,
            'sqrt': math.sqrt,
            'abs': abs,
            'round': round,
            'floor': math.floor,
            'ceil': math.ceil,
            'pi': math.pi,
            'e': math.e,
            'phi': (1 + math.sqrt(5)) / 2,
            'factorial': math.factorial,
            'perm': math.perm,
            'comb': math.comb,
            'mean': statistics.mean,
            'median': statistics.median,
            'mode': statistics.mode,
            'sum': sum,
            'max': max,
            'min': min
        }
        
        # Replace ^ with ** for exponentiation
        expression = expression.replace('^', '**')
        
        # Evaluate safely
        result = eval(expression, {"__builtins__": {}}, safe_dict)
        
        # Format result nicely
        if isinstance(result, float):
            if result.is_integer():
                return int(result)
            else:
                return round(result, 6)
        return result
        
    except Exception as e:
        return f"Error: {str(e)}"
`;

        // Simulate Python calculation (since we can't run Python directly)
        // This is a JavaScript implementation that mimics Python behavior
        
        let expression = match[1].trim();
        
        // Replace common Python syntax
        expression = expression
            .replace(/\^/g, '**')
            .replace(/sin\(/g, 'Math.sin(')
            .replace(/cos\(/g, 'Math.cos(')
            .replace(/tan\(/g, 'Math.tan(')
            .replace(/log\(/g, 'Math.log(')
            .replace(/log10\(/g, 'Math.log10(')
            .replace(/sqrt\(/g, 'Math.sqrt(')
            .replace(/abs\(/g, 'Math.abs(')
            .replace(/floor\(/g, 'Math.floor(')
            .replace(/ceil\(/g, 'Math.ceil(')
            .replace(/round\(/g, 'Math.round(')
            .replace(/pi/g, 'Math.PI')
            .replace(/e/g, 'Math.E')
            .replace(/phi/g, '((1 + Math.sqrt(5)) / 2)')
            .replace(/factorial\(/g, 'factorial(')
            .replace(/perm\(/g, 'perm(')
            .replace(/comb\(/g, 'comb(');

        // Helper functions for factorial, permutations, combinations
        function factorial(n) {
            if (n < 0 || n > 170) return Infinity;
            if (n === 0 || n === 1) return 1;
            let result = 1;
            for (let i = 2; i <= n; i++) {
                result *= i;
            }
            return result;
        }

        function perm(n, k) {
            if (k > n) return 0;
            return factorial(n) / factorial(n - k);
        }

        function comb(n, k) {
            if (k > n) return 0;
            return factorial(n) / (factorial(k) * factorial(n - k));
        }

        // Handle array functions
        if (expression.includes('mean(') || expression.includes('median(') || expression.includes('mode(')) {
            // Extract array from expression
            const arrayMatch = expression.match(/(mean|median|mode)\(\[([^\]]+)\]\)/);
            if (arrayMatch) {
                const func = arrayMatch[1];
                const arrayStr = arrayMatch[2];
                const numbers = arrayStr.split(',').map(n => parseFloat(n.trim()));
                
                if (func === 'mean') {
                    const result = numbers.reduce((a, b) => a + b, 0) / numbers.length;
                    expression = expression.replace(/mean\(\[[^\]]+\]\)/, result);
                } else if (func === 'median') {
                    const sorted = [...numbers].sort((a, b) => a - b);
                    const mid = Math.floor(sorted.length / 2);
                    const result = sorted.length % 2 === 0 
                        ? (sorted[mid - 1] + sorted[mid]) / 2 
                        : sorted[mid];
                    expression = expression.replace(/median\(\[[^\]]+\]\)/, result);
                } else if (func === 'mode') {
                    const counts = {};
                    numbers.forEach(n => counts[n] = (counts[n] || 0) + 1);
                    const maxCount = Math.max(...Object.values(counts));
                    const modes = Object.keys(counts).filter(n => counts[n] === maxCount);
                    const result = modes.length === 1 ? parseFloat(modes[0]) : modes.map(n => parseFloat(n));
                    expression = expression.replace(/mode\(\[[^\]]+\]\)/, Array.isArray(result) ? result[0] : result);
                }
            }
        }

        // Evaluate the expression safely
        const result = Function('"use strict"; return (' + expression + ')')();

        if (!isFinite(result)) {
            return await message.reply('*⚠️ Invalid calculation!*');
        }

        let response = `*_Python Expression_:* ${match[1]}\n`;
        response += `*_Result_:* ${result}`;
        
        // Add precision info for floating point results
        if (typeof result === 'number' && !Number.isInteger(result)) {
            response += `\n*_Rounded_:* ${result.toFixed(6)}`;
        }

        await message.reply(response);

    } catch (error) {
        await message.reply('*❌ Invalid calculation!*\nPlease check your expression.');
    }
});

// Unit converter using Python-style calculations
Module({
    pattern: 'convert ?(.*)',
    fromMe: isPrivateBot,
    desc: 'Unit converter with Python calculations',
    type: 'utility'
}, async (message, match) => {
    
    if (!match[1]) {
        return await message.reply(`*📏 Unit Converter*

*Usage:* .convert value from_unit to_unit

*Supported Units:*
• Length: m, km, cm, mm, ft, in, yd, mi
• Weight: kg, g, mg, lb, oz, ton
• Temperature: C, F, K
• Area: m2, km2, cm2, mm2, ft2, in2
• Volume: L, mL, m3, cm3, ft3, in3, gal
• Speed: m/s, km/h, mph, ft/s
• Time: s, min, h, day, week, month, year

*Examples:*
.convert 100 km to mi
.convert 32 C to F
.convert 5 kg to lb
.convert 100 m2 to ft2`);
    }

    try {
        const input = match[1].trim().toLowerCase();
        const parts = input.split(' to ');
        
        if (parts.length !== 2) {
            return await message.reply('*❌ Invalid format!*\nUse: .convert value from_unit to_unit');
        }

        const [valuePart, toUnit] = parts;
        const valueParts = valuePart.trim().split(' ');
        
        if (valueParts.length < 2) {
            return await message.reply('*❌ Invalid format!*\nUse: .convert value from_unit to_unit');
        }

        const value = parseFloat(valueParts[0]);
        const fromUnit = valueParts[1];

        if (isNaN(value)) {
            return await message.reply('*❌ Invalid value!*\nPlease provide a valid number.');
        }

        // Conversion factors (Python-style dictionary)
        const conversions = {
            // Length
            'm': { 'km': 0.001, 'cm': 100, 'mm': 1000, 'ft': 3.28084, 'in': 39.3701, 'yd': 1.09361, 'mi': 0.000621371 },
            'km': { 'm': 1000, 'cm': 100000, 'mm': 1000000, 'ft': 3280.84, 'in': 39370.1, 'yd': 1093.61, 'mi': 0.621371 },
            'cm': { 'm': 0.01, 'km': 0.00001, 'mm': 10, 'ft': 0.0328084, 'in': 0.393701, 'yd': 0.0109361, 'mi': 0.00000621371 },
            'mm': { 'm': 0.001, 'km': 0.000001, 'cm': 0.1, 'ft': 0.00328084, 'in': 0.0393701, 'yd': 0.00109361, 'mi': 0.000000621371 },
            'ft': { 'm': 0.3048, 'km': 0.0003048, 'cm': 30.48, 'mm': 304.8, 'in': 12, 'yd': 0.333333, 'mi': 0.000189394 },
            'in': { 'm': 0.0254, 'km': 0.0000254, 'cm': 2.54, 'mm': 25.4, 'ft': 0.0833333, 'yd': 0.0277778, 'mi': 0.000015783 },
            'yd': { 'm': 0.9144, 'km': 0.0009144, 'cm': 91.44, 'mm': 914.4, 'ft': 3, 'in': 36, 'mi': 0.000568182 },
            'mi': { 'm': 1609.34, 'km': 1.60934, 'cm': 160934, 'mm': 1609340, 'ft': 5280, 'in': 63360, 'yd': 1760 },

            // Weight
            'kg': { 'g': 1000, 'mg': 1000000, 'lb': 2.20462, 'oz': 35.274, 'ton': 0.001 },
            'g': { 'kg': 0.001, 'mg': 1000, 'lb': 0.00220462, 'oz': 0.035274, 'ton': 0.000001 },
            'mg': { 'kg': 0.000001, 'g': 0.001, 'lb': 0.00000220462, 'oz': 0.000035274, 'ton': 0.000000001 },
            'lb': { 'kg': 0.453592, 'g': 453.592, 'mg': 453592, 'oz': 16, 'ton': 0.000453592 },
            'oz': { 'kg': 0.0283495, 'g': 28.3495, 'mg': 28349.5, 'lb': 0.0625, 'ton': 0.0000283495 },
            'ton': { 'kg': 1000, 'g': 1000000, 'mg': 1000000000, 'lb': 2204.62, 'oz': 35274 },

            // Temperature
            'c': { 'f': (c) => (c * 9/5) + 32, 'k': (c) => c + 273.15 },
            'f': { 'c': (f) => (f - 32) * 5/9, 'k': (f) => (f - 32) * 5/9 + 273.15 },
            'k': { 'c': (k) => k - 273.15, 'f': (k) => (k - 273.15) * 9/5 + 32 }
        };

        // Handle temperature conversions separately
        if (fromUnit === 'c' && toUnit === 'f') {
            const result = (value * 9/5) + 32;
            return await message.reply(`*🌡️ Conversion Result*\n\n${value}°C = ${result.toFixed(2)}°F`);
        } else if (fromUnit === 'c' && toUnit === 'k') {
            const result = value + 273.15;
            return await message.reply(`*🌡️ Conversion Result*\n\n${value}°C = ${result.toFixed(2)}K`);
        } else if (fromUnit === 'f' && toUnit === 'c') {
            const result = (value - 32) * 5/9;
            return await message.reply(`*🌡️ Conversion Result*\n\n${value}°F = ${result.toFixed(2)}°C`);
        } else if (fromUnit === 'f' && toUnit === 'k') {
            const result = (value - 32) * 5/9 + 273.15;
            return await message.reply(`*🌡️ Conversion Result*\n\n${value}°F = ${result.toFixed(2)}K`);
        } else if (fromUnit === 'k' && toUnit === 'c') {
            const result = value - 273.15;
            return await message.reply(`*🌡️ Conversion Result*\n\n${value}K = ${result.toFixed(2)}°C`);
        } else if (fromUnit === 'k' && toUnit === 'f') {
            const result = (value - 273.15) * 9/5 + 32;
            return await message.reply(`*🌡️ Conversion Result*\n\n${value}K = ${result.toFixed(2)}°F`);
        }

        // Regular unit conversions
        if (conversions[fromUnit] && conversions[fromUnit][toUnit]) {
            const result = value * conversions[fromUnit][toUnit];
            const fromUnitDisplay = fromUnit.toUpperCase();
            const toUnitDisplay = toUnit.toUpperCase();
            
            return await message.reply(`*📏 Conversion Result*\n\n${value} ${fromUnitDisplay} = ${result.toFixed(6)} ${toUnitDisplay}`);
        }

        return await message.reply('*❌ Unsupported units!*\nUse .convert to see available units.');

    } catch (error) {
        await message.reply('*❌ Conversion error!*\nPlease check your input format.');
    }
});

// Export for potential external use
module.exports = {
    pythonCalc: true,
    unitConverter: true
};
